package tests;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;

import utils.Constants;
import daos.EmployeeDao;
import daos.ProjectDao;
import entities.Address;
import entities.Employee;
import entities.Project;

public class JpaTest {

	EntityManagerFactory factory;
	EntityManager manager;
	EntityTransaction transaction;

	public static void main(String[] args) {
		new JpaTest().initializeTest();
	}

	private void close() {
		manager.close();
		factory.close();
	}

	private void initializeFactoryManagerAndTransaction() {
		this.factory = Persistence.createEntityManagerFactory(Constants.persistence_unit);
		this.manager = factory.createEntityManager();
		this.transaction = manager.getTransaction();
	}

	private void initializeTest() {

		// testInsertEmployeeWithAddress();
		// testInsertEmployeeWithProjects();
		// testInsertProjectWithEmployees();
		// testSelectEmployeeById();
		// testRemoveEmployeeById();
		// testUpdateEmployeeSalary();
		// testSelectEmployees();
		testSelectEmployeesWithSalary();
		testSelectAllNames();
		testSelecttAllNamesAndBirthdays();
	}

	public void testInsertProjectWithEmployees() {

		initializeFactoryManagerAndTransaction();

		Calendar calendar = Calendar.getInstance();

		calendar.set(1985, Calendar.OCTOBER, 15);
		Employee employee1 = new Employee("Marcio", calendar.getTime(), 1000.00);

		calendar.set(1990, Calendar.JANUARY, 20);
		Employee employee2 = new Employee("Fernando", calendar.getTime(), 2000.00);

		List<Employee> employees = new ArrayList<Employee>();
		employees.add(employee1);
		employees.add(employee2);

		Project project = new Project("Z", employees);

		List<Project> projects = new ArrayList<Project>();
		projects.add(project);

		employee1.setProjects(projects);
		employee2.setProjects(projects);

		ProjectDao dao = new ProjectDao(manager);

		transaction.begin();
		dao.insert(project);
		transaction.commit();

		close();
	}

	public void testInsertEmployeeWithAddress() {

		initializeFactoryManagerAndTransaction();

		Address address = new Address(10000, "Rua N", "So Paulo", "SP");

		Calendar calendar = Calendar.getInstance();
		calendar.set(1985, Calendar.MAY, 15);

		Employee p = new Employee("Mario", calendar.getTime(), 10000.00, address);

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		dao.insert(p);
		transaction.commit();

		close();
	}

	public void testInsertEmployeeWithProjects() {

		initializeFactoryManagerAndTransaction();

		Project project1 = new Project("A");
		Project project2 = new Project("B");
		Project project3 = new Project("C");

		List<Project> projects = new ArrayList<Project>();
		projects.add(project1);
		projects.add(project2);
		projects.add(project3);

		Calendar calendar = Calendar.getInstance();
		calendar.set(1985, Calendar.OCTOBER, 25);
		Employee employee = new Employee("Fbio", calendar.getTime(), 800000.00, projects);

		List<Employee> employees = new ArrayList<Employee>();
		employees.add(employee);

		project1.setEmployees(employees);
		project2.setEmployees(employees);
		project3.setEmployees(employees);

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		dao.insert(employee);
		transaction.commit();

		close();
	}

	public List<Employee> testSelectEmployees() {

		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);
		List<Employee> employees = dao.select();

		for (Employee employee : employees) {
			System.out.println(employee);
		}

		close();

		return employees;
	}

	public Employee testSelectEmployeeById() {

		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);

		Employee employee = dao.selectById(7);

		System.out.println(employee);

		close();

		return employee;
	}

	public void testRemoveEmployeeById() {

		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		dao.deleteById(7);
		transaction.commit();

		close();
	}

	public void testUpdateEmployeeSalary() {

		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		dao.update(1, 12000);
		transaction.commit();

		close();
	}

	public void testSelectEmployeesWithSalary() {

		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		List<Employee> employees = dao.selectWithSalaryGreaterThan(3000);
		transaction.commit();

		for (Employee employee : employees) {
			System.out.println(employee);
		}

		close();
	}

	public void testSelectAllNames() {

		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		List<String> employees = dao.selectAllNames();
		transaction.commit();

		System.out.println(employees);

		close();
	}
	
	public void testSelecttAllNamesAndBirthdays(){
		
		initializeFactoryManagerAndTransaction();

		EmployeeDao dao = new EmployeeDao(manager);

		transaction.begin();
		List<Object[]> employees = dao.selectAllNamesAndBirthday();
		transaction.commit();

		for (Object[] objects : employees) {
			System.out.println("name: " + objects[0]);
			System.out.println("birthday: " + objects[1]);
			System.out.println();
		}

		close();
	}

}